// Load and save data to the MetaDb.
/* global sc, Packages */

function moduleFunction(config) {
  // Initialize $$ with provided config or default
  let $$ = config || require('./debug')({ debug: true, path: module.id });

  let PropertyToMetaDb = Packages.agorum.api.common.utils.PropertyToMetaDb;
  let MetaDbToProperty = Packages.agorum.api.common.utils.MetaDbToProperty;
  let property = require('common/property');

  /**
   * Loads a bundle from the MetaDb and returns the unwrapped property.
   *
   * @param {string} bundle - The name of the bundle to load.
   * @param {Object} [context] - Optional context object.
   * @returns {any} - The unwrapped property from the MetaDb bundle.
   */
  function load(bundle, context) {
    return property.unwrap(new MetaDbToProperty(context || sc).getBundle(bundle));
  }

  /**
   * Saves data to a bundle in the MetaDb.
   *
   * @param {string} bundle - The name of the bundle to save data to.
   * @param {any} data - The data to save.
   * @param {Object} [context] - Optional context object.
   */
  function save(bundle, data, context) {
    new PropertyToMetaDb(context || sc).put(bundle, property.from(data));
  }

  // Return the module functions
  return {
    load: load,
    save: save
  };
}

// Initialize $$ when the module is required without parameters
let moduleExports = moduleFunction();

// Export the module function and its methods
module.exports = Object.assign(moduleFunction, moduleExports);
